/*
 * Decompiled with CFR 0.152.
 */
package com.rcx.materialis.util;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import com.mojang.math.Transformation;
import com.rcx.materialis.util.ITintingModifier;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.util.GsonHelper;
import slimeknights.mantle.client.model.util.MantleItemLayerModel;
import slimeknights.mantle.util.ItemLayerPixels;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.client.modifiers.IBakedModifierModel;
import slimeknights.tconstruct.library.client.modifiers.IUnbakedModifierModel;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class TintedModifierModel
implements IBakedModifierModel {
    public static final IUnbakedModifierModel UNBAKED_INSTANCE = new Unbaked(-1);
    private final Material[] textures;
    private final int color;

    public TintedModifierModel(@Nullable Material smallTexture, @Nullable Material largeTexture, int color) {
        this.color = color;
        this.textures = new Material[]{smallTexture, largeTexture};
    }

    public TintedModifierModel(@Nullable Material smallTexture, @Nullable Material largeTexture) {
        this(smallTexture, largeTexture, -1);
    }

    @Nullable
    public Object getCacheKey(IToolStackView tool, ModifierEntry entry) {
        if (entry.getModifier() instanceof ITintingModifier) {
            return new GlowingModifierCacheKey(entry.getModifier(), ((ITintingModifier)entry.getModifier()).getLuminosity(tool));
        }
        return entry.getModifier();
    }

    public ImmutableList<BakedQuad> getQuads(IToolStackView tool, ModifierEntry modifier, Function<Material, TextureAtlasSprite> spriteGetter, Transformation transforms, boolean isLarge, int startTintIndex, @Nullable ItemLayerPixels pixels) {
        int index = isLarge ? 1 : 0;
        int luminosity = 0;
        if (modifier.getModifier() instanceof ITintingModifier) {
            luminosity = ((ITintingModifier)modifier.getModifier()).getLuminosity(tool);
        }
        return MantleItemLayerModel.getQuadsForSprite((int)this.color, (int)startTintIndex, (TextureAtlasSprite)spriteGetter.apply(this.textures[index]), (Transformation)transforms, (int)luminosity, (ItemLayerPixels)pixels);
    }

    public int getTintIndexes() {
        return 1;
    }

    public int getTint(IToolStackView tool, ModifierEntry entry, int index) {
        if (entry.getModifier() instanceof ITintingModifier) {
            return ((ITintingModifier)entry.getModifier()).getTint(tool);
        }
        return -1;
    }

    private static class GlowingModifierCacheKey {
        private final Modifier modifier;
        private final int luminosity;

        public GlowingModifierCacheKey(Modifier modifier, int luminosity) {
            this.modifier = modifier;
            this.luminosity = luminosity;
        }

        public Modifier getModifier() {
            return this.modifier;
        }

        public int getLuminosity() {
            return this.luminosity;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GlowingModifierCacheKey)) {
                return false;
            }
            GlowingModifierCacheKey other = (GlowingModifierCacheKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getLuminosity() != other.getLuminosity()) {
                return false;
            }
            Modifier this$modifier = this.getModifier();
            Modifier other$modifier = other.getModifier();
            return !(this$modifier == null ? other$modifier != null : !this$modifier.equals(other$modifier));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GlowingModifierCacheKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLuminosity();
            Modifier $modifier = this.getModifier();
            result = result * 59 + ($modifier == null ? 43 : $modifier.hashCode());
            return result;
        }

        public String toString() {
            return "TintedModifierModel.GlowingModifierCacheKey(modifier=" + this.getModifier() + ", luminosity=" + this.getLuminosity() + ")";
        }
    }

    private static class Unbaked
    implements IUnbakedModifierModel {
        private final int color;

        @Nullable
        public IBakedModifierModel forTool(Function<String, Material> smallGetter, Function<String, Material> largeGetter) {
            Material smallTexture = smallGetter.apply("");
            Material largeTexture = largeGetter.apply("");
            if (smallTexture != null || largeTexture != null) {
                return new TintedModifierModel(smallTexture, largeTexture, this.color);
            }
            return null;
        }

        public IUnbakedModifierModel configure(JsonObject data) {
            int color = JsonHelper.parseColor((String)GsonHelper.m_13851_((JsonObject)data, (String)"color", (String)""));
            if (color != this.color) {
                return new Unbaked(color);
            }
            return this;
        }

        public Unbaked(int color) {
            this.color = color;
        }
    }
}

